<?php
/* --------------------------------------------------------------
 AdminServiceProviderRegistration.php 2020-03-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Kernel\Bootstrapper;

use Gambio\Admin\Application\ErrorHandling\AdminErrorServiceProvider;
use Gambio\Admin\Application\Http\AdminHttpServiceProvider;
use Gambio\Admin\Application\Token\TokenServiceProvider;
use Gambio\Core\Configuration\ConfigurationServiceProvider;
use Gambio\Admin\Customer\SimpleCustomerServiceProvider;
use Gambio\Admin\Layout\Menu\AdminMenuServiceProvider;
use Gambio\Admin\Layout\Smarty\LayoutLoaderServiceProvider;
use Gambio\Admin\ParcelService\ParcelServiceServiceProvider;
use Gambio\Admin\UserConfiguration\UserConfigurationServiceProvider;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Application\ServiceProviders\Abstraction\ServiceProvider;

/**
 * Class AdminServiceProviderRegistration
 * @package Gambio\Admin\Application\Kernel\Bootstrapper
 */
class AdminServiceProviderRegistration extends AbstractBootstrapper
{
    private const CORE_SERVICE_PROVIDERS = [
        AdminHttpServiceProvider::class,
        AdminMenuServiceProvider::class,
        LayoutLoaderServiceProvider::class,
        UserConfigurationServiceProvider::class,
        SimpleCustomerServiceProvider::class,
        TokenServiceProvider::class,
        AdminErrorServiceProvider::class,
    ];
    
    
    private const DOMAIN_SERVICE_PROVIDERS = [
        ConfigurationServiceProvider::class,
        ParcelServiceServiceProvider::class,
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        /** @var ServiceProvider $serviceProvider */
        
        foreach (self::CORE_SERVICE_PROVIDERS as $provider) {
            $serviceProvider = new $provider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
        
        foreach (self::DOMAIN_SERVICE_PROVIDERS as $provider) {
            $serviceProvider = new $provider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
    }
    
}